/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractSimpleGitCommandHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.git.ui.internal.actions.PushToRemoteHandler;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class PushHandler
extends AbstractSimpleGitCommandHandler {
    private static final String COMMAND = "push";
    private static final String ORIGIN = "origin";

    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        Set<GitRepository> repos = this.getSelectedRepositories();
        if (CollectionsUtil.isEmpty(repos)) {
            this.openError(Messages.CommitAction_NoRepo_Title, Messages.CommitAction_NoRepo_Message);
            return null;
        }
        if (!this.supportsMultipleRepoOperation() && repos.size() > 1) {
            this.openError(Messages.CommitAction_MultipleRepos_Title, Messages.CommitAction_MultipleRepos_Message);
            return null;
        }
        Object[] command = this.getCommand();
        if (ArrayUtil.isEmpty((Object[])command)) {
            return null;
        }
        for (GitRepository repo : repos) {
            String currentBranch = repo.currentBranch();
            if (repo.remotes().contains(ORIGIN) && repo.matchingRemoteBranch(currentBranch) == null) {
                PushToRemoteHandler.pushBranchToRemote(repo, currentBranch, ORIGIN);
                continue;
            }
            this.runCommandAsJob((String[])command, repo);
        }
        return null;
    }

    protected String[] getCommand() {
        return new String[]{COMMAND};
    }

    protected void postLaunch(GitRepository repo) {
        repo.firePushEvent();
    }

    protected boolean calculateEnabled() {
        for (GitRepository repo : this.getSelectedRepositories()) {
            if (repo == null || repo.remotes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected boolean supportsMultipleRepoOperation() {
        return true;
    }
}

